<?php
/*
 * Copyright (C) 2020 Andreu Bisquerra Gaya <jove@bisquerra.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

header('Access-Control-Allow-Origin: *');
define('NOSCANPOSTFORINJECTION', '1');
define('NOCSRFCHECK', '1');

// Try main.inc.php using relative path
if (! $res && file_exists("../master.inc.php")) $res=@include "../master.inc.php";
if (! $res && file_exists("../../master.inc.php")) $res=@include "../../master.inc.php";
if (! $res && file_exists("../../../master.inc.php")) $res=@include "../../../master.inc.php";
if (! $res) die("Include of main fails");

$conf->global->MAIN_SECURITY_CSRF_WITH_TOKEN=0;
ini_set('max_input_vars','200000');

require_once DOL_DOCUMENT_ROOT.'/core/class/dolreceiptprinter.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';

$invoice= json_decode(GETPOST('invoice'));

$printer = new dolReceiptPrinter($db);
$ret = $printer->sendToPrinter($invoice, $conf->global->TAKEPOS_TEMPLATE_TO_USE_FOR_INVOICES, $conf->global->TAKEPOS_CONNECTOR_PRINTER_1);